#include <BWAPI.h>
#include "../Addons/Util.h"
#include <UnitGroupManager.h>


#pragma once
using namespace BWAPI;
using namespace std;

const int size = 4;

class ZerglingManager
{
public:
	     // Global Variables
		 // Red Home = 31, 7
		 // Blue Home = 66, 119
		 Unit *enemy;
		 
		 int groupSize;
		 bool findPosition;

		 int counter;


		 bool grab;
		 bool groupPhase;
		 bool groupGather;
		 bool groupAttack;

		 Position firstGroupCoord[size];
		 Position secondGroupCoord[size];

		 UnitGroup GroupZerg;
		 UnitGroup groupOne;
		 UnitGroup groupTwo;

	    ~ZerglingManager(void)
        {
		}
		void onFrame(BWAPI::Game *Broodwar)
		{
			/****************************************************************************************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			*******************************************ZEKE'S CODE BEGINS HERE***********************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			*****************************************************************************************************************
			****************************************************************************************************************/

			// PHASE 1 *****************************
			// *************************************
			//
			// DETERMINE WHERE OUR START LOCATION IS
			// SET PROPER COORDINATES
			//
			//
			// *************************************
			// *************************************
			if(!findPosition)
			{
				listMake(Broodwar);
				findPosition = true;
			}

			// PHASE 2 ***************************************
			// ***********************************************
			//
			// DIVIDE THE 6 ZERGLINGS INTO TWO GROUPS.
			// BOTH GROUPS INHERIT THE GROUPZERG LIST ELEMENTS
			//
			// ***********************************************
			// ***********************************************

			if(!grab)
			{
				for(std::set<Unit*>::const_iterator i = Broodwar->self()->getUnits().begin(); i != Broodwar->self()->getUnits().end(); i++)
				{
					if((*i)->getType() == UnitTypes::Zerg_Zergling)
						GroupZerg.insert((*i));
				}

				groupSize = GroupZerg.size();

				if(groupSize == 6)
					grab = true;
			}

			if(grab)
			{
				if(GroupZerg.size() == 6)
				{
					if(!groupPhase)
					{
						groupSize = GroupZerg.size();

						for(std::set<Unit*>::iterator i = GroupZerg.begin(); i != GroupZerg.end(); i++)
						{
							if(counter != (groupSize/2))
							{
								groupOne.insert((*i));
								counter++;
							}
						}

						groupTwo = GroupZerg - groupOne;
						groupPhase = true;

					}
				}
			}

			int sizeOne = groupOne.size();
			int sizeTwo = groupTwo.size();

			// PHASE 2 ****************************
			// ************************************
			//
			// FIGURE OUT WHAT MAP WE'RE ON
			// SEND ZERGLINGS TO PROPER COORDINATES
			//
			// ************************************
			// ************************************

			//groupGather
			if(groupPhase)
			{
				if(!groupGather)
				{
					for(std::set<Unit*>::const_iterator i = groupOne.begin(); i != groupOne.end(); i++)
					{
						(*i)->attack(firstGroupCoord[0]);
					}

					for(std::set<Unit*>::const_iterator i = groupTwo.begin(); i != groupTwo.end(); i++)
					{
						(*i)->attack(secondGroupCoord[0]);
					}
				}

				groupGather = true;
			}

			if(groupGather)
			{
				if(!groupAttack)
				{
					// FOR GROUP ONE...
				
					for(std::set<Unit*>::const_iterator i = groupOne.begin(); i != groupOne.end(); i++)
					{
						for(int j = 1; j < size; j++)
						{
							if(firstGroupCoord[j] != Positions::None)
							{
								(*i)->move(Position(firstGroupCoord[j]), true);
							}
							else
							{
								j = j - 1;
								(*i)->attack(Position(firstGroupCoord[j]), true);
								break;
							}
						}
					}
				
					//FOR GROUP TWO
				
					for(std::set<Unit*>::const_iterator i = groupTwo.begin(); i != groupTwo.end(); i++)
					{
						
						for(int j = 1; j < size; j++)
						{
							if(secondGroupCoord[j] != Positions::None)
							{
								(*i)->move(Position(secondGroupCoord[j]), true);
							}
							else
							{
								j = j - 1;
								(*i)->attack(Position(secondGroupCoord[j]), true);
								break;
							}
						}
					}

				groupAttack = true;
				}
			}
			
		}

		void listMake(BWAPI::Game *Broodwar)
		{
			for(int i = 0; i < size; i++)
			{
				firstGroupCoord[i] = Positions::None;
				secondGroupCoord[i] = Positions::None;
			}

			// IF WE SPAWN AT BLUE, THEN COORDINATES ARE AS FOLLOWS...
			if(Broodwar->self()->getStartLocation() != TilePosition(31, 7))
			{
				firstGroupCoord[0] = Position(TilePosition(57, 16));
				firstGroupCoord[1] = Position(TilePosition(34, 16));
				firstGroupCoord[2] = Position(TilePosition(29, 11));

				secondGroupCoord[0] = Position(TilePosition(57, 16));
				secondGroupCoord[1] = Position(TilePosition(44, 4));
				secondGroupCoord[2] = Position(TilePosition(37, 4));
				secondGroupCoord[3] = Position(TilePosition(29, 5));
			}
			// IF WE SPAWN AT RED, THEN COORDINATES ARE AS FOLLOWS...
			else
			{
				firstGroupCoord[0] = Position(TilePosition(38, 112));
				firstGroupCoord[1] = Position(TilePosition(46, 120));
				firstGroupCoord[2] = Position(TilePosition(62, 125));
				firstGroupCoord[3] = Position(TilePosition(68, 123));

				secondGroupCoord[0] = Position(TilePosition(38, 112));
				secondGroupCoord[1] = Position(TilePosition(49, 112));
				secondGroupCoord[2] = Position(TilePosition(66, 110));
				secondGroupCoord[3] = Position(TilePosition(69, 116));
			}
		}
				

					


};